package org.msh.tb.reports2.variables.contacts;

import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.Gender;
import org.msh.tb.reports2.variables.EnumFieldVariable;

/**
 * Created by rmemoria on 30/3/17.
 */
public class ContactGenderVariable extends EnumFieldVariable {
    public static final String ID = "contact-gender";

    public ContactGenderVariable() {
        super(ID, "manag.reportgen.var.contact-gender", "gender", Gender.class);
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        String alias = def.table("tbcase").join("id", "tbcontact.case_id").getAlias();
        def.addRestriction(alias + ".gender is not null");
        def.select(alias + ".gender");
    }

    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        String alias = def.table("tbcase").join("id", "tbcontact.case_id").getAlias();
        def.addRestriction(alias + ".gender = :contact_gender");
        def.addParameter("contact_gender", value.asInteger());
    }
}
